/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.recap;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.catalogos.PorcentajeRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Retencion;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Compensacion;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.ats.modelo.util.ValidadorCompensaciones;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Consumo
extends ObjetoModeloSucesorValidableAnotado<Recap>
implements InformacionEditable<Consumo>,
Importable {
    private static final long serialVersionUID = -855893785963787232L;
    private ValidadorCompensaciones validador = new ValidadorCompensaciones();
    public static final String C_CONSUMO_CERO = "consumoCero";
    public static final String C_CONSUMO_GRAVADO = "consumoGravado";
    public static final String C_TOTAL_CONSUMO = "totalConsumo";
    public static final String C_MONTO_IVA = "montoIva";
    public static final String C_COMISION = "comision";
    public static final String C_NUM_VOUCHERS = "numVouchers";
    public static final String C_RET_IVA_BIENES = "retencionIvaBienes";
    public static final String C_RET_IVA_SERVICIOS = "retencionIvaServicios";
    public static final String C_RET_IVA_SERVICIOS_50 = "retencionIvaServicios50";
    public static final String C_RET_IVA_CIEN = "retencionIvaCien";
    public static final String C_RET_IVA_DIEZ = "retencionIvaCien";
    public static final String C_RET_IVA_VEINTE = "retencionIvaCien";
    private static final String COMPENSACIONES = "compensaciones";
    private static final String M_CONSUMO_CERO = "Consumo tarifa 0%";
    private static final String M_CONSUMO_GRAVADO = "Consumo Gravado";
    private static final String M_TOTAL_CONSUMO = "Total Consumo";
    private static final String M_COMISION = "Comisi\u00f3n";
    private static final String M_VOUCHERS = "No de Vouchers";
    private static final String MSG_NUM_VAUCHERS = "El valor  No de Vouchers debe ser solo n\u00fameros. Diferente de cero.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. ";
    @NotNull(message="Debe ingresar el valor de Consumo tarifa 0%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Consumo tarifa 0% debe ser 12 enteros y 2 decimales. ")
    private String consumoCero = "0.00";
    @NotNull(message="Debe ingresar el valor de Consumo Gravado")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Consumo Gravado debe ser 12 enteros y 2 decimales. ")
    private String consumoGravado = "0.00";
    @NotNull(message="Debe ingresar el valor de Total Consumo")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Total Consumo debe ser 12 enteros y 2 decimales. ")
    private String totalConsumo = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto IVA debe ser 12 enteros y 2 decimales. ")
    private String montoIva = "0.00";
    @NotNull(message="Debe ingresar el valor de Comisi\u00f3n")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Comisi\u00f3n debe ser 12 enteros y 2 decimales. ")
    private String comision = "0.00";
    @NotNull(message="Debe ingresar el valor de No de Vouchers")
    @Pattern(regexp="\\d{1,9}", message="El valor  No de Vouchers debe ser solo n\u00fameros. Diferente de cero.  M\u00ednimo 1 d\u00edgito, m\u00e1ximo 9. ")
    private String numVouchers;
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 30% Bienes")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 30% Bienes debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaBienes = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 50% Servicios")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 50% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaServicios50 = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 70% Servicios")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 70% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaServicios = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 100%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 100% debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaCien = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 10% Bienes")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 10% Bienes debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaDiez = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 20% Servicios")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 20% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaVeinte = "0.00";
    private BigDecimal totalConsumoCalculado;
    private BigDecimal montoIvaCalculado;
    private BigDecimal retencionIvaBienesCalculado = new BigDecimal("0.00");
    private BigDecimal retencionIvaServiciosCalculado = new BigDecimal("0.00");
    private BigDecimal retencionIvaServicios50Calculado = new BigDecimal("0.00");
    private BigDecimal retencionIvaCienCalculado = new BigDecimal("0.00");
    private BigDecimal sumaRetenciones;
    private BigDecimal retencionIvaDiezCalculado;
    private BigDecimal retencionIvaVeinteCalculado;
    private final List<Compensacion> compensaciones;
    private boolean modificaIva;

    public Consumo() {
        this.totalConsumoCalculado = new BigDecimal("0.00");
        this.montoIvaCalculado = new BigDecimal("0.00");
        this.sumaRetenciones = new BigDecimal("0.00");
        this.retencionIvaDiezCalculado = new BigDecimal("0.00");
        this.retencionIvaVeinteCalculado = new BigDecimal("0.00");
        this.compensaciones = new ArrayList<Compensacion>();
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.validarNumVouchers(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (this.validarComision(resultado).esEstadoFallido()) {
            return resultado;
        }
        this.validador.validarCompensaciones(resultado, this.consumoGravado, this.compensaciones, ((Iva)this.getRaizModelo()).periodo);
        if (!this.validarMontoIva(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarTotalConsumo(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (this.validarTotalRetencionMontoIva(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva10(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva20(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva30Bienes(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva50(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva70Servicios(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIvaCien(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    private ResultadoValidacion validarRetencionIva10(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIvaDiez()), this.retencionIvaDiezCalculado, "Retenci\u00f3n IVA 10% Bienes");
    }

    private ResultadoValidacion validarRetencionIva20(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIvaVeinte()), this.retencionIvaVeinteCalculado, "Retenci\u00f3n IVA 20% Servicios");
    }

    private ResultadoValidacion validarRetencionIva30Bienes(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaBienes()), this.retencionIvaBienesCalculado, "Retenci\u00f3n IVA 30% Bienes");
    }

    private ResultadoValidacion validarRetencionIva50(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIvaServicios50()), this.retencionIvaServicios50Calculado, "Retenci\u00f3n IVA 50% Servicios");
    }

    private ResultadoValidacion validarRetencionIva70Servicios(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaServicios()), this.retencionIvaServiciosCalculado, "Retenci\u00f3n IVA 70% Servicios");
    }

    private ResultadoValidacion validarRetencionIvaCien(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaCien()), this.retencionIvaCienCalculado, "Retenci\u00f3n IVA 100%");
    }

    public Consumo crearCopiaEdicion() {
        Consumo copia = new Consumo();
        copia.setConsumoCero(this.consumoCero);
        copia.setConsumoGravado(this.consumoGravado);
        copia.setTotalConsumo(this.totalConsumo);
        copia.setMontoIva(this.montoIva);
        copia.setComision(this.comision);
        copia.setNumVouchers(this.numVouchers);
        copia.setRetencionIvaBienes(this.retencionIvaBienes);
        copia.setRetencionIvaServicios(this.retencionIvaServicios);
        copia.setRetencionIvaServicios50(this.retencionIvaServicios50);
        copia.setRetencionIvaCien(this.retencionIvaCien);
        copia.setRetencionIvaDiez(this.retencionIvaDiez);
        copia.setRetencionIvaVeinte(this.retencionIvaVeinte);
        copia.getCompensaciones().addAll(this.getCompensaciones());
        copia.setPropietario((ObjetoModelo)((Recap)this.propietario));
        return copia;
    }

    public void actualizarInformacion(Consumo copiaEdicion) {
        this.setConsumoCero(copiaEdicion.getConsumoCero());
        this.setConsumoGravado(copiaEdicion.getConsumoGravado());
        this.setTotalConsumo(copiaEdicion.getTotalConsumo());
        this.setMontoIva(copiaEdicion.getMontoIva());
        this.setComision(copiaEdicion.getComision());
        this.setNumVouchers(copiaEdicion.getNumVouchers());
        this.setRetencionIvaBienes(copiaEdicion.getRetencionIvaBienes());
        this.setRetencionIvaServicios(copiaEdicion.getRetencionIvaServicios());
        this.setRetencionIvaServicios50(copiaEdicion.getRetencionIvaServicios50());
        this.setRetencionIvaCien(copiaEdicion.getRetencionIvaCien());
        this.setRetencionIvaDiez(copiaEdicion.getRetencionIvaDiez());
        this.setRetencionIvaVeinte(copiaEdicion.getRetencionIvaVeinte());
        this.getCompensaciones().clear();
        this.getCompensaciones().addAll(copiaEdicion.getCompensaciones());
    }

    protected void validacionAnotadaExitosa() {
        this.sumarConsumos();
        this.calcularMontoIva();
        this.calcularRetenciones();
    }

    private ResultadoValidacion validarTotalConsumo(ResultadoValidacion resultado) {
        if (this.totalConsumoCalculado.compareTo(Util.getBigDecimal(this.getTotalConsumo())) != 0) {
            if (Util.isMargenErrorMasMenos(this.totalConsumoCalculado, this.getTotalConsumo(), Constantes.MARGEN_ERROR)) {
                return resultado.pasarValidacionAdvertencia(String.format("El valor %s es diferente al valor calculado por el sistema %s", M_TOTAL_CONSUMO, this.totalConsumoCalculado.toString()));
            }
            return resultado.fallarValidacion(String.format("El valor %s es diferente al valor calculado por el sistema %s", M_TOTAL_CONSUMO, this.totalConsumoCalculado.toString()));
        }
        return resultado;
    }

    private ResultadoValidacion validarMontoIva(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoIva()).compareTo(Util.getBigDecimal(this.getConsumoGravado())) == 1) {
            return resultado.fallarValidacion("El valor Monto Iva no puede ser mayor al valor Consumo Gravado");
        }
        if (Util.getBigDecimal(this.getMontoIva()).compareTo(this.montoIvaCalculado) != 0) {
            return resultado.pasarValidacionAdvertencia(String.format("El valor %s es diferente al valor calculado por el sistema %s", "Monto IVA", this.montoIvaCalculado.toString()));
        }
        return resultado;
    }

    private ResultadoValidacion validarComision(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getComision()).compareTo(Util.getBigDecimal(this.getTotalConsumo())) == 1) {
            return resultado.fallarValidacion("El valor Comisi\u00f3n no puede ser mayor al valor Total Consumo");
        }
        return resultado;
    }

    private ResultadoValidacion validarNumVouchers(ResultadoValidacion resultado) {
        if (Util.getInteger(this.getNumVouchers()) == 0) {
            return resultado.fallarValidacion("El valor N\u00famero de Vouchers debe ser mayor a cero");
        }
        return resultado;
    }

    private ResultadoValidacion validarTotalRetencionMontoIva(ResultadoValidacion resultado) {
        this.sumarRetenciones(this.getRetencionIvaBienes(), this.getRetencionIvaServicios(), this.getRetencionIvaCien(), this.getRetencionIvaVeinte(), this.getRetencionIvaDiez(), this.getRetencionIvaServicios50());
        if (this.sumaRetenciones.compareTo(Util.getBigDecimal(this.getMontoIva())) == 1) {
            return resultado.fallarValidacion("La sumatoria de las Retenciones no puede ser mayor al valor Monto IVA");
        }
        return resultado;
    }

    private void sumarConsumos() {
        this.totalConsumoCalculado = Util.sumarValores(this.getConsumoCero(), this.getConsumoGravado());
    }

    protected void sumarRetenciones(String ... valores) {
        this.sumaRetenciones = Util.sumarValores(valores);
    }

    private void calcularMontoIva() {
        this.montoIvaCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getConsumoGravado()), ((Iva)this.getRaizModelo()).getPorcentajeIva());
        if (!this.isModificaIva()) {
            this.setMontoIva(String.valueOf(this.montoIvaCalculado));
        }
    }

    public boolean isModificaIva() {
        return this.modificaIva;
    }

    public void setModificaIva(boolean modificaIva) {
        this.modificaIva = modificaIva;
    }

    public void calcularRetenciones() {
        this.retencionIvaBienesCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_BIENES_30);
        this.retencionIvaServiciosCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_SERV_70);
        this.retencionIvaServicios50Calculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_50);
        this.retencionIvaCienCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_CIEN);
        this.retencionIvaDiezCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_DIEZ);
        this.retencionIvaVeinteCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_VEINTE);
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName(C_CONSUMO_CERO);
        Element eValor = (Element)valorList.item(0);
        this.consumoCero = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName(C_CONSUMO_GRAVADO);
        eValor = (Element)valorList.item(0);
        this.consumoGravado = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName(C_TOTAL_CONSUMO);
        eValor = (Element)valorList.item(0);
        this.totalConsumo = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName(C_MONTO_IVA);
        eValor = (Element)valorList.item(0);
        this.montoIva = eValor.getTextContent().trim();
        this.importarCompensacionesDesdeJunio2016(elemento);
        valorList = elemento.getElementsByTagName(C_COMISION);
        eValor = (Element)valorList.item(0);
        this.comision = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("numeroVouchers");
        eValor = (Element)valorList.item(0);
        this.numVouchers = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valorRetBienes");
        eValor = (Element)valorList.item(0);
        this.retencionIvaBienes = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valorRetServicios");
        eValor = (Element)valorList.item(0);
        this.retencionIvaServicios = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valRetServ100");
        eValor = (Element)valorList.item(0);
        this.retencionIvaCien = eValor.getTextContent().trim();
        if (Util.existeElementoImportar(elemento, "valRetBien10")) {
            valorList = elemento.getElementsByTagName("valRetBien10");
            eValor = (Element)valorList.item(0);
            this.retencionIvaDiez = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "valRetServ20")) {
            valorList = elemento.getElementsByTagName("valRetServ20");
            eValor = (Element)valorList.item(0);
            this.retencionIvaVeinte = eValor.getTextContent().trim();
        }
        if (Util.existeElementoImportar(elemento, "valRetServ50")) {
            valorList = elemento.getElementsByTagName("valRetServ50");
            eValor = (Element)valorList.item(0);
            this.retencionIvaServicios50 = eValor.getTextContent().trim();
        }
        return this;
    }

    private void importarCompensacionesDesdeJunio2016(Element elemento) {
        NodeList compensaciones = elemento.getElementsByTagName("compensacion");
        int numeroNodo = 0;
        while (numeroNodo < compensaciones.getLength()) {
            Node nodo = compensaciones.item(numeroNodo);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                Compensacion compensacion = new Compensacion();
                compensacion.importar(elem, null);
                this.agregarCompensacion(compensacion);
            }
            ++numeroNodo;
        }
    }

    public String getConsumoCero() {
        return this.consumoCero;
    }

    public String getConsumoGravado() {
        return this.consumoGravado;
    }

    public String getTotalConsumo() {
        return this.totalConsumo;
    }

    public String getMontoIva() {
        return this.montoIva;
    }

    public String getComision() {
        return this.comision;
    }

    public String getNumVouchers() {
        return this.numVouchers;
    }

    public String getRetencionIvaBienes() {
        return this.retencionIvaBienes;
    }

    public String getRetencionIvaServicios() {
        return this.retencionIvaServicios;
    }

    public String getRetencionIvaCien() {
        return this.retencionIvaCien;
    }

    public String getRetencionIvaDiez() {
        return this.retencionIvaDiez;
    }

    public String getRetencionIvaVeinte() {
        return this.retencionIvaVeinte;
    }

    public String getRetencionIvaServicios50() {
        return this.retencionIvaServicios50;
    }

    public void setConsumoCero(String consumoCero) {
        String oldValue = this.consumoCero;
        this.consumoCero = consumoCero;
        this.firePropertyChange(C_CONSUMO_CERO, oldValue, this.consumoCero);
        this.setTotalConsumo(String.valueOf(this.totalConsumoCalculado));
    }

    public void setConsumoGravado(String consumoGravado) {
        String oldValue = this.consumoGravado;
        this.consumoGravado = consumoGravado;
        this.firePropertyChange(C_CONSUMO_GRAVADO, oldValue, this.consumoGravado);
        this.setTotalConsumo(String.valueOf(this.totalConsumoCalculado));
    }

    public void setTotalConsumo(String totalConsumo) {
        String oldValue = this.totalConsumo;
        this.totalConsumo = totalConsumo;
        this.firePropertyChange(C_TOTAL_CONSUMO, oldValue, this.totalConsumo);
    }

    public void setMontoIva(String montoIva) {
        String oldValue = this.montoIva;
        this.montoIva = montoIva;
        this.firePropertyChange(C_MONTO_IVA, oldValue, this.montoIva);
    }

    public void setComision(String comision) {
        String oldValue = this.comision;
        this.comision = comision;
        this.firePropertyChange(C_COMISION, oldValue, this.comision);
    }

    public void setNumVouchers(String numVouchers) {
        String oldValue = this.numVouchers;
        this.numVouchers = numVouchers;
        this.firePropertyChange(C_NUM_VOUCHERS, oldValue, this.numVouchers);
    }

    public void setRetencionIvaBienes(String retencionIvaBienes) {
        String oldValue = this.retencionIvaBienes;
        this.retencionIvaBienes = retencionIvaBienes;
        this.firePropertyChange(C_RET_IVA_BIENES, oldValue, this.retencionIvaBienes);
    }

    public void setRetencionIvaServicios(String retencionIvaServicios) {
        String oldValue = this.retencionIvaServicios;
        this.retencionIvaServicios = retencionIvaServicios;
        this.firePropertyChange(C_RET_IVA_SERVICIOS, oldValue, this.retencionIvaServicios);
    }

    public void setRetencionIvaCien(String retencionIvaCien) {
        String oldValue = this.retencionIvaCien;
        this.retencionIvaCien = retencionIvaCien;
        this.firePropertyChange("retencionIvaCien", oldValue, this.retencionIvaCien);
    }

    public void setRetencionIvaDiez(String retencionIvaDiez) {
        String oldValue = this.retencionIvaDiez;
        this.retencionIvaDiez = retencionIvaDiez;
        this.firePropertyChange("retencionIvaCien", oldValue, this.retencionIvaDiez);
    }

    public void setRetencionIvaVeinte(String retencionIvaVeinte) {
        String oldValue = this.retencionIvaVeinte;
        this.retencionIvaVeinte = retencionIvaVeinte;
        this.firePropertyChange("retencionIvaCien", oldValue, this.retencionIvaVeinte);
    }

    public void setRetencionIvaServicios50(String retencionIvaServicios50) {
        String oldValue = this.retencionIvaServicios50;
        this.retencionIvaServicios50 = retencionIvaServicios50;
        this.firePropertyChange(C_RET_IVA_SERVICIOS_50, oldValue, this.retencionIvaServicios50);
    }

    public void agregarCompensacion(Compensacion compensacion) {
        compensacion.setPropietario((ObjetoModelo)this);
        this.compensaciones.add(compensacion);
        this.firePropertyChange(COMPENSACIONES, null, this.compensaciones);
    }

    public boolean eliminarCompensaciones(Compensacion compensacion) {
        boolean eliminado = this.compensaciones.remove((Object)compensacion);
        if (eliminado) {
            this.firePropertyChange(COMPENSACIONES, null, this.compensaciones);
        }
        return eliminado;
    }

    public List<Compensacion> getCompensaciones() {
        return this.compensaciones;
    }
}

